


########

construct_datasets <- function(months_to_keep) {
  cald %>%
    mutate(month = as.character(month)) %>%
    
    left_join(
      cifval %>% mutate(month = as.character(month)),
      by = c("hs08", "month")
    ) %>% 
    
    filter(month %in% months_to_keep) %>%
    
    mutate(
      across(
        c(cald_2024, cald_2025, cifval_2024, cifval_2025),
        ~ as.numeric(as.character(.x))
      )
    ) %>%
    
    # collapse to hs08 cumulative totals
    group_by(hs08) %>%
    summarise(
      cald24 = sum(cald_2024, na.rm = TRUE),
      cald25 = sum(cald_2025, na.rm = TRUE),
      cif24  = sum(cifval_2024, na.rm = TRUE),
      cif25  = sum(cifval_2025, na.rm = TRUE),
      .groups = "drop"
    ) %>%
    
    # filtered by the exempted HS08 codes
    semi_join(
      food_tariffs_hs08 %>% mutate(hs08 = as.character(hs08)),
      by = "hs08"
    ) %>%
    
    mutate(
      hs08 = as.character(hs08),
      hs02 = substring(hs08, 1, 2)
    ) %>%
    
    # collapse to hs02 totals
    group_by(hs02) %>%
    summarise(
      total_cald24 = sum(cald24, na.rm = TRUE),
      total_cald25 = sum(cald25, na.rm = TRUE),
      total_cif24  = sum(cif24,  na.rm = TRUE),
      total_cif25  = sum(cif25,  na.rm = TRUE),
      .groups = "drop"
    ) %>%
    
    mutate(
      rate24 = total_cald24 / total_cif24,
      rate25 = total_cald25 / total_cif25,
      diff   = rate25 - rate24
    )
}


dataset_apr_aug <- construct_datasets(month.name[4:8])
dataset_jan_aug <- construct_datasets(month.name[1:8])

#use apr-aug data to estimate the change in tariff rate
tariff_rev_food <- dataset_apr_aug %>%
  select(hs02, rate24, rate25, diff)

#use jan-aug data to estimate the annualized imports impacted
annualized_imports_food <- dataset_jan_aug %>%
  select(hs02, total_cif25) %>%
  mutate(
    annualized_im = (total_cif25/8) *12
  )
#merge the two to have table1 or figure1
figure1 <- tariff_rev_food %>%
  left_join(annualized_imports_food, by = "hs02")




######

  






